const RPC_URLS = {
    Ethereum: "https://rpc.ankr.com/eth",
    BSC: "https://bsc-dataseed.binance.org/",
    Polygon: "https://polygon-rpc.com/",
    Arbitrum: "https://arb1.arbitrum.io/rpc",
    Optimism: "https://mainnet.optimism.io"
};

// Kiểm tra seed phrase hợp lệ (ethers v6)
function isValidSeed(seed) {
    try {
        ethers.Wallet.fromPhrase(seed); // Nếu lỗi -> seed không hợp lệ
        return true;
    } catch (e) {
        return false;
    }
}

// Hàm kiểm tra seed phrase và số dư trên nhiều blockchain
async function checkSeeds() {
    const input = document.getElementById("seedInput").value.trim();
    const resultElement = document.getElementById("result");
    resultElement.textContent = "🔄 Đang kiểm tra...";

    if (!input) {
        resultElement.textContent = "⚠️ Vui lòng nhập ít nhất một seed phrase.";
        return;
    }

    const seeds = input.split("\n").map(s => s.trim()).filter(Boolean);
    let results = [];

    for (let seed of seeds) {
        try {
            if (!isValidSeed(seed)) {
                results.push(`❌ Seed không hợp lệ: ${seed}`);
                continue;
            }

            const wallet = ethers.Wallet.fromPhrase(seed);
            const address = wallet.address;
            results.push(`✅ Seed hợp lệ: ${seed}\n🔹 Địa chỉ: ${address}`);

            // Kiểm tra số dư trên các blockchain
            for (const [chain, rpc] of Object.entries(RPC_URLS)) {
                const provider = new ethers.JsonRpcProvider(rpc);
                try {
                    const balance = await provider.getBalance(address);
                    const ethBalance = ethers.formatEther(balance);
                    results.push(`   🔸 ${chain}: ${ethBalance} ${chain === "BSC" ? "BNB" : "ETH"}`);
                } catch (e) {
                    results.push(`   ⚠️ Không thể kiểm tra trên ${chain}`);
                }
            }
            results.push("\n");
        } catch (error) {
            results.push(`⚠️ Lỗi với seed: ${seed} - ${error.message}`);
        }
    }

    resultElement.textContent = results.join("\n");
}
